<?php
/**
 * Shopping Cart Page
 * Display and manage items in shopping cart
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/csv-reader.php';

$csvReader = new CSVReader();
$pageTitle = 'Sepetim';

require_once __DIR__ . '/includes/header.php';

// Get cart from localStorage via AJAX if needed
$cartEmpty = !isset($_REQUEST['cart_data']);
?>

<div style="max-width: 1200px; margin: 0 auto; padding: 2rem 0;">
    <!-- Page Title -->
    <div style="margin-bottom: 2rem;">
        <h1>🛒 Alışveriş Sepetim</h1>
    </div>

    <!-- Cart Container (Grid: items + summary) -->
    <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem; min-height: 400px;">
        <!-- Cart Items -->
        <div>
            <div id="cart-items-container" style="background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 2px 12px rgba(0,0,0,0.08);">
                <!-- Items will be loaded by JavaScript -->
                <div style="padding: 2rem; text-align: center; color: #999;">
                    ⏳ Sepetiniz yükleniyor...
                </div>
            </div>
        </div>

        <!-- Order Summary -->
        <div>
            <div style="
                background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                color: white;
                padding: 2rem;
                border-radius: 12px;
                position: sticky;
                top: 100px;
            ">
                <h3 style="margin-top: 0;">Sipariş Özeti</h3>
                
                <div style="margin: 2rem 0; border-bottom: 1px solid rgba(255,255,255,0.3); padding-bottom: 1rem;">
                    <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                        <span>Ara Toplam:</span>
                        <span id="subtotal">$0.00</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                        <span>KDV (%18):</span>
                        <span id="tax">$0.00</span>
                    </div>
                    <div style="display: flex; justify-content: space-between; font-size: 0.9rem; color: rgba(255,255,255,0.8);">
                        <span>Kargo:</span>
                        <span id="shipping">Ücretsiz</span>
                    </div>
                </div>

                <div style="display: flex; justify-content: space-between; font-size: 1.3rem; font-weight: 600; margin-bottom: 2rem;">
                    <span>Toplam:</span>
                    <span id="total">$0.00</span>
                </div>

                <button 
                    id="checkout-btn"
                    onclick="proceedToCheckout()"
                    style="
                        width: 100%;
                        background: white;
                        color: #e63946;
                        border: none;
                        padding: 1rem;
                        border-radius: 8px;
                        font-weight: 600;
                        font-size: 1.1rem;
                        cursor: pointer;
                        transition: all 0.3s ease;
                    "
                    onmouseover="this.style.backgroundColor='#f0f0f0';"
                    onmouseout="this.style.backgroundColor='white';"
                >
                    Checkout İşlemine Git
                </button>

                <a 
                    href="<?php echo APP_URL; ?>/products.php"
                    style="
                        display: block;
                        text-align: center;
                        margin-top: 1rem;
                        color: white;
                        text-decoration: none;
                        padding: 0.75rem;
                        border: 1px solid white;
                        border-radius: 8px;
                        transition: all 0.3s ease;
                    "
                    onmouseover="this.style.backgroundColor='rgba(255,255,255,0.2)';"
                    onmouseout="this.style.backgroundColor='transparent';"
                >
                    Alışverişe Devam Et
                </a>

                <div style="margin-top: 2rem; padding-top: 2rem; border-top: 1px solid rgba(255,255,255,0.3);">
                    <p style="font-size: 0.85rem; margin: 0; text-align: center;">
                        💳 Güvenli ödeme Paddle tarafından sağlanmaktadır.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Empty Cart Message (Hidden by default) -->
<div id="empty-cart" style="display: none; text-align: center; padding: 4rem 2rem;">
    <h2 style="font-size: 2rem; margin-bottom: 1rem;">🛒 Sepetiniz Boş</h2>
    <p style="color: #999; margin-bottom: 2rem; font-size: 1.1rem;">
        Henüz ürün seçmemişsiniz. Lütfen ürün ekleyerek başlayın.
    </p>
    <a 
        href="<?php echo APP_URL; ?>/products.php"
        style="
            background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
            color: white;
            padding: 1rem 2rem;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s ease;
        "
        onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.3)';"
        onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';"
    >
        Ürünlere Göz At 💕
    </a>
</div>

<!-- JavaScript for Cart Management -->
<script>
// Product cache for price lookup
let productsCache = {};

async function loadCart() {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const cartContainer = document.getElementById('cart-items-container');
    const emptyCart = document.getElementById('empty-cart');

    if (cart.length === 0) {
        // Hide cart items, show empty message
        cartContainer.style.display = 'none';
        emptyCart.style.display = 'block';
        document.getElementById('checkout-btn').disabled = true;
        updateCartSummary([]);
        return;
    }

    // Show cart items, hide empty message
    cartContainer.style.display = 'block';
    emptyCart.style.display = 'none';
    document.getElementById('checkout-btn').disabled = false;

    // Fetch product data and build HTML
    const csv = <?php echo json_encode($csvReader->getAllProducts()); ?>;
    csv.forEach(product => {
        productsCache[product.id] = product;
    });

    let html = '';
    cart.forEach(item => {
        const product = productsCache[item.id];
        if (!product) return;

        html += `
            <div class="cart-item" data-product-id="${item.id}" style="
                padding: 1.5rem;
                border-bottom: 1px solid #eee;
                display: grid;
                grid-template-columns: 120px 1fr auto;
                gap: 1.5rem;
                align-items: center;
            ">
                <!-- Product Image -->
                <div>
                    <a href="<?php echo APP_URL; ?>/product-detail.php?id=${item.id}" style="text-decoration: none;">
                        <img src="${product.image}" alt="${product.title}" style="
                            width: 100%;
                            height: 120px;
                            object-fit: cover;
                            border-radius: 8px;
                        ">
                    </a>
                </div>

                <!-- Product Info -->
                <div>
                    <h4 style="margin: 0 0 0.5rem 0;">
                        <a href="<?php echo APP_URL; ?>/product-detail.php?id=${item.id}" style="color: #2d2d2d; text-decoration: none;">
                            ${product.title}
                        </a>
                    </h4>
                    <p style="color: #999; margin: 0.25rem 0; font-size: 0.9rem;">
                        ${product.category}
                    </p>
                    <p style="color: #e63946; font-weight: 600; margin: 0.5rem 0 0 0; font-size: 1.1rem;">
                        $${parseFloat(product.price).toFixed(2)}
                    </p>
                </div>

                <!-- Quantity & Remove -->
                <div style="text-align: right;">
                    <div style="
                        display: flex;
                        align-items: center;
                        gap: 0.5rem;
                        margin-bottom: 1rem;
                        background: #f5f5f5;
                        border-radius: 8px;
                        width: fit-content;
                        margin-left: auto;
                    ">
                        <button onclick="updateQuantity(${item.id}, -1)" style="
                            background: none;
                            border: none;
                            padding: 0.5rem 0.75rem;
                            cursor: pointer;
                            font-size: 1.1rem;
                        ">−</button>
                        <span style="min-width: 30px; text-align: center; font-weight: 600;">${item.quantity}</span>
                        <button onclick="updateQuantity(${item.id}, 1)" style="
                            background: none;
                            border: none;
                            padding: 0.5rem 0.75rem;
                            cursor: pointer;
                            font-size: 1.1rem;
                        ">+</button>
                    </div>
                    <button 
                        onclick="removeFromCart(${item.id})"
                        style="
                            background: #ffcccc;
                            color: #c41e3a;
                            border: none;
                            padding: 0.5rem 1rem;
                            border-radius: 6px;
                            cursor: pointer;
                            font-size: 0.9rem;
                            transition: all 0.3s ease;
                        "
                        onmouseover="this.style.backgroundColor='#ff9999';"
                        onmouseout="this.style.backgroundColor='#ffcccc';"
                    >
                        Kaldır ×
                    </button>
                </div>
            </div>
        `;
    });

    cartContainer.innerHTML = html;
    updateCartSummary(cart);
    updateCartCount();
}

function updateQuantity(productId, change) {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const item = cart.find(i => i.id === productId);

    if (!item) return;

    item.quantity = Math.max(1, item.quantity + change);
    localStorage.setItem('cart', JSON.stringify(cart));
    loadCart();
}

function removeFromCart(productId) {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const updatedCart = cart.filter(item => item.id !== productId);
    localStorage.setItem('cart', JSON.stringify(updatedCart));
    loadCart();
}

function updateCartSummary(cart) {
    const csv = <?php echo json_encode($csvReader->getAllProducts()); ?>;
    const productsMap = {};
    csv.forEach(p => productsMap[p.id] = p);

    let subtotal = 0;
    cart.forEach(item => {
        const product = productsMap[item.id];
        if (product) {
            subtotal += parseFloat(product.price) * item.quantity;
        }
    });

    const tax = subtotal * 0.18;
    const shipping = subtotal > 50 ? 0 : 0; // Free shipping
    const total = subtotal + tax + shipping;

    document.getElementById('subtotal').textContent = '$' + subtotal.toFixed(2);
    document.getElementById('tax').textContent = '$' + tax.toFixed(2);
    document.getElementById('shipping').textContent = shipping === 0 ? 'Ücretsiz' : '$' + shipping.toFixed(2);
    document.getElementById('total').textContent = '$' + total.toFixed(2);

    // Store total for checkout
    localStorage.setItem('cartTotal', total.toFixed(2));
}

function proceedToCheckout() {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    if (cart.length === 0) {
        alert('Sepetiniz boş!');
        return;
    }
    window.location.href = '<?php echo APP_URL; ?>/checkout.php';
}

function updateCartCount() {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
    document.getElementById('cart-count').textContent = totalItems;
}

// Load cart when page loads
window.addEventListener('DOMContentLoaded', loadCart);
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
