<?php
/**
 * Checkout Page
 * Handle order creation and Paddle payment integration
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/database.php';
require_once __DIR__ . '/includes/csv-reader.php';

$db = Database::getInstance();
$csvReader = new CSVReader();
$pageTitle = 'Ödeme İşlemi';

// Get cart from JavaScript via localStorage
$cart = isset($_REQUEST['cart_data']) ? json_decode($_REQUEST['cart_data'], true) : [];
$cartTotal = isset($_REQUEST['cartTotal']) ? (float)$_REQUEST['cartTotal'] : 0;

// Get current user if logged in
$userId = null;
if (isset($_SESSION['user'])) {
    $userId = $_SESSION['user']['id'];
}

require_once __DIR__ . '/includes/header.php';
?>

<div style="max-width: 800px; margin: 0 auto; padding: 2rem 0;">
    <!-- Page Title -->
    <div style="margin-bottom: 2rem;">
        <h1>💳 Ödeme İşlemi</h1>
    </div>

    <!-- Checkout Form (Two column: Left = form, Right = order summary) -->
    <form id="checkout-form" style="display: grid; grid-template-columns: 2fr 1fr; gap: 2rem;">
        <div>
            <!-- Customer Information -->
            <div style="
                background: white;
                padding: 2rem;
                border-radius: 12px;
                box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                margin-bottom: 2rem;
            ">
                <h3 style="margin-top: 0;">👤 Kişisel Bilgiler</h3>
                
                <div style="margin-bottom: 1.5rem;">
                    <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Ad Soyad *</label>
                    <input 
                        type="text" 
                        id="customer_name" 
                        name="customer_name"
                        required 
                        style="
                            width: 100%;
                            padding: 0.75rem;
                            border: 2px solid #eee;
                            border-radius: 8px;
                            font-size: 1rem;
                            box-sizing: border-box;
                            transition: border-color 0.3s ease;
                        "
                        onfocus="this.style.borderColor='#ff6b9d';"
                        onblur="this.style.borderColor='#eee';"
                    >
                </div>

                <div style="margin-bottom: 1.5rem;">
                    <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Email Adresi *</label>
                    <input 
                        type="email" 
                        id="customer_email" 
                        name="customer_email"
                        required 
                        style="
                            width: 100%;
                            padding: 0.75rem;
                            border: 2px solid #eee;
                            border-radius: 8px;
                            font-size: 1rem;
                            box-sizing: border-box;
                            transition: border-color 0.3s ease;
                        "
                        onfocus="this.style.borderColor='#ff6b9d';"
                        onblur="this.style.borderColor='#eee';"
                    >
                </div>

                <div style="margin-bottom: 1.5rem;">
                    <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Telefon Numarası</label>
                    <input 
                        type="tel" 
                        id="customer_phone" 
                        name="customer_phone"
                        pattern="[0-9+\-\s]*"
                        style="
                            width: 100%;
                            padding: 0.75rem;
                            border: 2px solid #eee;
                            border-radius: 8px;
                            font-size: 1rem;
                            box-sizing: border-box;
                            transition: border-color 0.3s ease;
                        "
                        onfocus="this.style.borderColor='#ff6b9d';"
                        onblur="this.style.borderColor='#eee';"
                    >
                </div>
            </div>

            <!-- Billing Address -->
            <div style="
                background: white;
                padding: 2rem;
                border-radius: 12px;
                box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                margin-bottom: 2rem;
            ">
                <h3 style="margin-top: 0;">📍 Faturalandırma Adresi</h3>
                
                <div style="margin-bottom: 1.5rem;">
                    <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Adres *</label>
                    <textarea 
                        id="billing_address" 
                        name="billing_address"
                        required 
                        rows="3"
                        style="
                            width: 100%;
                            padding: 0.75rem;
                            border: 2px solid #eee;
                            border-radius: 8px;
                            font-size: 1rem;
                            box-sizing: border-box;
                            transition: border-color 0.3s ease;
                        "
                        onfocus="this.style.borderColor='#ff6b9d';"
                        onblur="this.style.borderColor='#eee';"
                    ></textarea>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem;">
                    <div>
                        <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Şehir *</label>
                        <input 
                            type="text" 
                            id="billing_city" 
                            name="billing_city"
                            required 
                            style="
                                width: 100%;
                                padding: 0.75rem;
                                border: 2px solid #eee;
                                border-radius: 8px;
                                font-size: 1rem;
                                box-sizing: border-box;
                            "
                        >
                    </div>
                    <div>
                        <label style="display: block; color: #666; margin-bottom: 0.5rem; font-weight: 600;">Posta Kodu *</label>
                        <input 
                            type="text" 
                            id="billing_postal" 
                            name="billing_postal"
                            required 
                            style="
                                width: 100%;
                                padding: 0.75rem;
                                border: 2px solid #eee;
                                border-radius: 8px;
                                font-size: 1rem;
                                box-sizing: border-box;
                            "
                        >
                    </div>
                </div>
            </div>

            <!-- Additional Notes -->
            <div style="
                background: white;
                padding: 2rem;
                border-radius: 12px;
                box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                margin-bottom: 2rem;
            ">
                <h3 style="margin-top: 0;">📝 Ek Notlar</h3>
                
                <textarea 
                    id="notes" 
                    name="notes"
                    rows="3"
                    placeholder="Siparişiniz hakkında herhangi bir not varsa yazabilirsiniz..."
                    style="
                        width: 100%;
                        padding: 0.75rem;
                        border: 2px solid #eee;
                        border-radius: 8px;
                        font-size: 1rem;
                        box-sizing: border-box;
                    "
                ></textarea>
            </div>

            <!-- Terms & Conditions -->
            <div style="
                background: #faf8f6;
                padding: 1.5rem;
                border-radius: 12px;
                margin-bottom: 2rem;
            ">
                <label style="display: flex; align-items: flex-start; gap: 1rem;">
                    <input 
                        type="checkbox" 
                        id="accept_terms" 
                        name="accept_terms"
                        required 
                        style="margin-top: 0.25rem; cursor: pointer;"
                    >
                    <span style="color: #666;">
                        Sözleşmeyi okudum, kabul ettim. Dosyası kaydedildiği ve 
                        bir saat sonra erişilebilir olacağını anladım.
                    </span>
                </label>
            </div>
        </div>

        <!-- Right Column: Order Summary & Payment -->
        <div>
            <!-- Order Summary Cart -->
            <div style="
                background: white;
                padding: 2rem;
                border-radius: 12px;
                box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                position: sticky;
                top: 100px;
                margin-bottom: 2rem;
            ">
                <h3 style="margin-top: 0;">Sipariş Özeti</h3>
                
                <div id="order-items" style="
                    max-height: 300px;
                    overflow-y: auto;
                    margin-bottom: 1.5rem;
                    padding-bottom: 1.5rem;
                    border-bottom: 1px solid #eee;
                ">
                    <!-- Items will be loaded by JavaScript -->
                </div>

                <!-- Price Breakdown -->
                <div style="margin-bottom: 2rem;">
                    <div style="
                        display: flex;
                        justify-content: space-between;
                        margin-bottom: 0.75rem;
                        color: #666;
                    ">
                        <span>Ara Toplam:</span>
                        <span id="summary-subtotal">$0.00</span>
                    </div>
                    <div style="
                        display: flex;
                        justify-content: space-between;
                        margin-bottom: 0.75rem;
                        color: #666;
                    ">
                        <span>KDV (%18):</span>
                        <span id="summary-tax">$0.00</span>
                    </div>
                    <div style="
                        display: flex;
                        justify-content: space-between;
                        padding-top: 1rem;
                        border-top: 2px solid #eee;
                        font-size: 1.3rem;
                        font-weight: 600;
                    ">
                        <span>Toplam:</span>
                        <span id="summary-total" style="color: #e63946;">$0.00</span>
                    </div>
                </div>

                <!-- Paddle Checkout Button -->
                <button 
                    type="button"
                    id="paddle-btn"
                    onclick="initiatePaddlePayment()"
                    style="
                        width: 100%;
                        background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                        color: white;
                        border: none;
                        padding: 1rem;
                        border-radius: 8px;
                        font-weight: 600;
                        font-size: 1.1rem;
                        cursor: pointer;
                        transition: all 0.3s ease;
                    "
                    onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.3)';"
                    onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';"
                >
                    💳 Paddle ile Öde
                </button>

                <p style="text-align: center; color: #999; font-size: 0.85rem; margin-top: 1rem;">
                    Ödeme Paddle tarafından güvenli şekilde işlenir.
                </p>
            </div>

            <!-- Back to Cart -->
            <a 
                href="<?php echo APP_URL; ?>/cart.php"
                style="
                    display: block;
                    text-align: center;
                    color: #666;
                    text-decoration: none;
                    padding: 1rem;
                    border: 2px solid #eee;
                    border-radius: 8px;
                    transition: all 0.3s ease;
                "
                onmouseover="this.style.borderColor='#ff6b9d'; this.style.color='#ff6b9d';"
                onmouseout="this.style.borderColor='#eee'; this.style.color='#666';"
            >
                ← Sepete Dön
            </a>
        </div>
    </form>
</div>

<!-- Paddle Script -->
<script src="https://cdn.paddle.com/paddle/v2/paddle.js"></script>

<script>
// Initialize Paddle
Paddle.Setup({
    token: '<?php echo PADDLE_CLIENT_TOKEN; ?>'
});

function initiatePaddlePayment() {
    const form = document.getElementById('checkout-form');
    
    // Validate form
    if (!form.checkValidity()) {
        alert('Lütfen tüm gerekli alanları doldurunuz.');
        return;
    }

    // Collect form data
    const formData = new FormData(form);
    const customerData = {
        name: formData.get('customer_name'),
        email: formData.get('customer_email'),
        phone: formData.get('customer_phone'),
        address: formData.get('billing_address'),
        city: formData.get('billing_city'),
        postal: formData.get('billing_postal'),
        notes: formData.get('notes')
    };

    // Get cart and total
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const total = parseFloat(localStorage.getItem('cartTotal')) || 0;

    if (cart.length === 0) {
        alert('Sepetiniz boş!');
        return;
    }

    // Create order record in database before payment
    createOrder(customerData, cart, total);
}

function createOrder(customerData, cart, total) {
    // Send AJAX request to create order
    fetch('<?php echo APP_URL; ?>/api/orders/create.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            customer: customerData,
            cart: cart,
            total: total,
            user_id: <?php echo $userId ? $userId : 'null'; ?>
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Store order ID for later reference
            localStorage.setItem('pendingOrderId', data.order_id);
            
            // Proceed to Paddle payment
            openPaddleCheckout(data.order_id, total, customerData.email);
        } else {
            alert('Sipariş oluşturulamadı: ' + (data.message || 'Bilinmeyen hata'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Bir hata oluştu. Lütfen tekrar deneyiniz.');
    });
}

function openPaddleCheckout(orderId, total, email) {
    // Open Paddle Checkout
    // Note: This requires proper Paddle setup with product IDs
    Paddle.Checkout.open({
        items: [{
            priceId: '<?php echo PADDLE_PRICE_ID; ?>', // This should be configured in config.php
            quantity: 1,
            // Custom data
            customData: {
                orderId: orderId,
                email: email
            }
        }],
        customer: {
            email: email
        },
        successUrl: '<?php echo APP_URL; ?>/order-success.php',
        settings: {
            variant: 'embedded',
            allowLogout: false,
        }
    });
}

// Load cart summary on page load
document.addEventListener('DOMContentLoaded', function() {
    loadOrderSummary();
    
    // Pre-fill form if user is logged in
    <?php if (isset($_SESSION['user'])): ?>
        document.getElementById('customer_name').value = '<?php echo htmlspecialchars($_SESSION['user']['username']); ?>';
        document.getElementById('customer_email').value = '<?php echo htmlspecialchars($_SESSION['user']['email']); ?>';
    <?php endif; ?>
});

function loadOrderSummary() {
    const csv = <?php echo json_encode($csvReader->getAllProducts()); ?>;
    const productsMap = {};
    csv.forEach(p => productsMap[p.id] = p);

    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const orderItemsDiv = document.getElementById('order-items');
    let subtotal = 0;

    orderItemsDiv.innerHTML = '';
    
    cart.forEach(item => {
        const product = productsMap[item.id];
        if (!product) return;

        const itemTotal = parseFloat(product.price) * item.quantity;
        subtotal += itemTotal;

        const itemHtml = `
            <div style="
                display: flex;
                justify-content: space-between;
                margin-bottom: 1rem;
                align-items: center;
            ">
                <div>
                    <strong>${product.title.substring(0, 30)}...</strong>
                    <p style="margin: 0.25rem 0; color: #999; font-size: 0.9rem;">
                        x${item.quantity}
                    </p>
                </div>
                <span style="font-weight: 600;">$${itemTotal.toFixed(2)}</span>
            </div>
        `;
        orderItemsDiv.innerHTML += itemHtml;
    });

    const tax = subtotal * 0.18;
    const total = subtotal + tax;

    document.getElementById('summary-subtotal').textContent = '$' + subtotal.toFixed(2);
    document.getElementById('summary-tax').textContent = '$' + tax.toFixed(2);
    document.getElementById('summary-total').textContent = '$' + total.toFixed(2);
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
