<?php
/**
 * CDVectors Configuration File
 * =============================
 * Database settings, API keys, and application constants
 */

// Prevent direct access
if (basename($_SERVER['PHP_SELF']) === basename(__FILE__)) {
    http_response_code(403);
    exit('Forbidden');
}

// ============================================
// DATABASE CONFIGURATION
// ============================================

// MySQL/MariaDB Connection Settings
define('DB_HOST', 'localhost');           // Database host
define('DB_USER', 'cdvectors');           // Database username
define('DB_PASS', 'your_db_password');    // Database password
define('DB_NAME', 'cdvectors_db');        // Database name
define('DB_PORT', 3306);                  // Database port
define('DB_CHARSET', 'utf8mb4');          // Character set for UTF-8 support

// ============================================
// APPLICATION SETTINGS
// ============================================

define('APP_NAME', 'CDVectors');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'https://yourdomain.com');  // Change to your domain
define('APP_ENV', 'production');              // development or production

// ============================================
// SECURITY SETTINGS
// ============================================

// CSRF Token Salt
define('CSRF_TOKEN_SALT', 'your_csrf_salt_here_change_this');

// Session Configuration
define('SESSION_TIMEOUT', 3600);  // 1 hour in seconds
define('SESSION_NAME', 'cdvectors_session');

// Password Hashing (bcrypt)
define('PASSWORD_ALGO', PASSWORD_BCRYPT);
define('PASSWORD_OPTIONS', ['cost' => 10]);

// ============================================
// PADDLE PAYMENT API
// ============================================

define('PADDLE_VENDOR_ID', 'your_vendor_id');        // Get from Paddle Dashboard
define('PADDLE_VENDOR_AUTH_CODE', 'your_auth_code'); // Get from Paddle Dashboard
define('PADDLE_ENVIRONMENT', 'production');          // sandbox or production
define('PADDLE_API_URL', PADDLE_ENVIRONMENT === 'sandbox' 
    ? 'https://sandbox-api.paddle.com/products'
    : 'https://api.paddle.com/products'
);

// ============================================
// EMAIL CONFIGURATION
// ============================================

// SMTP Settings
define('SMTP_HOST', 'smtp.gmail.com');              // Change to your SMTP server
define('SMTP_PORT', 587);                           // TLS port
define('SMTP_SECURE', 'tls');                       // tls or ssl
define('SMTP_USER', 'your_email@gmail.com');        // Your email
define('SMTP_PASS', 'your_app_password');           // App password (not regular password)

// Sender Information
define('EMAIL_FROM', 'cdvectors@gmail.com');
define('EMAIL_FROM_NAME', 'CDVectors');
define('ADMIN_EMAIL', 'cdvectors@gmail.com');

// ============================================
// FILE UPLOAD SETTINGS
// ============================================

define('UPLOAD_DIR', __DIR__ . '/../uploads/');
define('CSV_DIR', __DIR__ . '/../csv/');
define('MAX_UPLOAD_SIZE', 50 * 1024 * 1024);  // 50MB
define('ALLOWED_EXTENSIONS', ['zip', 'ai', 'eps', 'svg', 'pdf', 'png', 'jpg']);

// ============================================
// PAGINATION
// ============================================

define('ITEMS_PER_PAGE', 12);      // Products per page
define('ADMIN_PER_PAGE', 20);      // Admin panel items per page

// ============================================
// TIMEZONE
// ============================================

date_default_timezone_set('UTC');

// ============================================
// ERROR REPORTING (Adjust based on environment)
// ============================================

if (APP_ENV === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
    ini_set('log_errors', 1);
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
}

ini_set('error_log', __DIR__ . '/../logs/error.log');

// ============================================
// HELPER FUNCTION: Security Headers
// ============================================

function setSecurityHeaders() {
    header('X-Content-Type-Options: nosniff');
    header('X-Frame-Options: DENY');
    header('X-XSS-Protection: 1; mode=block');
    header('Strict-Transport-Security: max-age=31536000; includeSubDomains');
    header('Content-Security-Policy: default-src \'self\'; script-src \'self\' \'unsafe-inline\'; style-src \'self\' \'unsafe-inline\'');
}

// Call security headers
setSecurityHeaders();

// ============================================
// START SESSION
// ============================================

session_name(SESSION_NAME);
session_start();

// ============================================
// END OF CONFIG
// ============================================
