<?php
/**
 * CDVectors Header Template
 * =========================
 * Include at the top of every page
 */

require_once __DIR__ . '/config.php';

// Get current user if logged in
$currentUser = isset($_SESSION['user_id']) ? $_SESSION['user'] : null;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) . ' - ' . APP_NAME : APP_NAME; ?></title>
    
    <!-- Meta Tags -->
    <meta name="description" content="<?php echo isset($pageDescription) ? htmlspecialchars($pageDescription) : 'Premium vector graphics and design templates'; ?>">
    <meta name="robots" content="index, follow">
    <meta name="author" content="<?php echo APP_NAME; ?>">
    
    <!-- Open Graph (Social Media) -->
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo APP_NAME; ?>">
    <meta property="og:title" content="<?php echo isset($pageTitle) ? htmlspecialchars($pageTitle) : APP_NAME; ?>">
    <meta property="og:description" content="<?php echo isset($pageDescription) ? htmlspecialchars($pageDescription) : 'Premium vector graphics'; ?>">
    <meta property="og:url" content="<?php echo APP_URL; ?>">
    
    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo APP_URL; ?>/assets/css/style.css">
    <link rel="stylesheet" href="<?php echo APP_URL; ?>/assets/css/responsive.css">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo APP_URL; ?>/assets/favicon.ico">
    
    <!-- Additional CSS if needed -->
    <?php if (isset($additionalCSS)) echo $additionalCSS; ?>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar">
        <div class="navbar-container">
            <!-- Logo -->
            <div class="navbar-logo">
                <a href="<?php echo APP_URL; ?>">
                    <span class="logo-text"><?php echo APP_NAME; ?></span>
                </a>
            </div>
            
            <!-- Navigation Menu -->
            <ul class="navbar-menu">
                <li><a href="<?php echo APP_URL; ?>/products.php">Ürünler</a></li>
                <li><a href="<?php echo APP_URL; ?>/categories.php">Kategoriler</a></li>
                <li><a href="<?php echo APP_URL; ?>/contact.php">İletişim</a></li>
                
                <?php if ($currentUser): ?>
                    <!-- Logged In User -->
                    <li class="navbar-user">
                        <a href="<?php echo APP_URL; ?>/dashboard.php">
                            <span class="user-icon">👤</span>
                            <?php echo htmlspecialchars($currentUser['first_name'] ?? $currentUser['username']); ?>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a href="<?php echo APP_URL; ?>/dashboard.php">Hesabım</a></li>
                            <li><a href="<?php echo APP_URL; ?>/orders.php">Siparişlerim</a></li>
                            <li><a href="<?php echo APP_URL; ?>/profile.php">Profil Ayarları</a></li>
                            <?php if ($currentUser['is_admin']): ?>
                                <li><hr></li>
                                <li><a href="<?php echo APP_URL; ?>/admin/dashboard.php">Admin Panel</a></li>
                            <?php endif; ?>
                            <li><hr></li>
                            <li><a href="<?php echo APP_URL; ?>/logout.php">Çıkış Yap</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <!-- Guest User -->
                    <li><a href="<?php echo APP_URL; ?>/login.php" class="btn-login">Giriş Yap</a></li>
                    <li><a href="<?php echo APP_URL; ?>/register.php" class="btn-register">Kayıt Ol</a></li>
                <?php endif; ?>
            </ul>
            
            <!-- Cart Icon -->
            <div class="navbar-cart">
                <a href="<?php echo APP_URL; ?>/cart.php" class="cart-link">
                    <span class="cart-icon">🛒</span>
                    <span class="cart-count" id="cart-count">0</span>
                </a>
            </div>
            
            <!-- Mobile Menu Toggle -->
            <button class="mobile-menu-toggle" id="mobile-menu-toggle">
                <span></span>
                <span></span>
                <span></span>
            </button>
        </div>
    </nav>

    <!-- Flash Messages -->
    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="alert alert-<?php echo $_SESSION['flash_type'] ?? 'info'; ?>" role="alert">
            <?php 
            echo htmlspecialchars($_SESSION['flash_message']);
            unset($_SESSION['flash_message']);
            unset($_SESSION['flash_type']);
            ?>
        </div>
    <?php endif; ?>

    <!-- Main Content Container -->
    <main class="main-content-wrapper">
