<?php
/**
 * CDVectors Homepage
 * Main landing page with hero section and featured products
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/csv-reader.php';

$csvReader = new CSVReader();
$pageTitle = 'CDVectors - Premium Aşk & Evlilik Vektör Grafikleri';
$pageDescription = 'Profesyonel tasarımcılar için yüksek kaliteli aşk ve evlilik temalı vektör grafikleri. AI, SVG, PNG ve EPS formatlarında.';

require_once __DIR__ . '/includes/header.php';

// Get popular products
$popularProducts = $csvReader->getPopularProducts(6);
$categories = $csvReader->getCategories();
?>

<!-- Hero Section -->
<div style="
    background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
    color: white;
    padding: 5rem 2rem;
    text-align: center;
    position: relative;
    overflow: hidden;
">
    <!-- Background decorative elements -->
    <div style="position: absolute; top: 20px; right: 50px; font-size: 4rem; opacity: 0.1;">💕</div>
    <div style="position: absolute; bottom: 50px; left: 30px; font-size: 5rem; opacity: 0.1;">💍</div>
    
    <div style="position: relative; z-index: 2; max-width: 800px; margin: 0 auto;">
        <h1 style="
            font-size: 3.5rem;
            margin: 0 0 1rem 0;
            font-weight: 700;
            text-shadow: 0 2px 10px rgba(0,0,0,0.2);
        ">
            ❤️ CDVectors
        </h1>
        
        <p style="
            font-size: 1.3rem;
            margin: 0 0 2rem 0;
            opacity: 0.95;
            line-height: 1.6;
        ">
            Aşk, Evlilik ve Romantizm Temalı<br>
            <strong>Premium Vektör Grafikleri</strong>
        </p>
        
        <p style="
            font-size: 1rem;
            margin: 0 0 2rem 0;
            opacity: 0.85;
            line-height: 1.8;
        ">
            Profesyonel tasarımcılar, düğün planlayıcıları ve yaratıcılar için.<br>
            1000+ kaliteli ürün, hepsi anında indirmeye hazır! 🎨
        </p>
        
        <div style="display: flex; gap: 1rem; justify-content: center; flex-wrap: wrap;">
            <a 
                href="<?php echo APP_URL; ?>/products.php"
                style="
                    background: white;
                    color: #e63946;
                    padding: 1rem 2.5rem;
                    border-radius: 10px;
                    text-decoration: none;
                    font-weight: 700;
                    font-size: 1.1rem;
                    transition: all 0.3s ease;
                    display: inline-block;
                    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
                "
                onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 25px rgba(0,0,0,0.3)';"
                onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(0,0,0,0.2)';"
            >
                🛍️ Ürünleri Keşfet
            </a>
            
            <a 
                href="<?php echo APP_URL; ?>/products.php?category=vectors"
                style="
                    background: rgba(255,255,255,0.2);
                    color: white;
                    padding: 1rem 2.5rem;
                    border-radius: 10px;
                    text-decoration: none;
                    font-weight: 700;
                    font-size: 1.1rem;
                    border: 2px solid white;
                    transition: all 0.3s ease;
                    display: inline-block;
                "
                onmouseover="this.style.backgroundColor='rgba(255,255,255,0.3)';"
                onmouseout="this.style.backgroundColor='rgba(255,255,255,0.2)';"
            >
                👰 Evlilik Koleksiyonu
            </a>
        </div>
    </div>
</div>

<!-- Stats Section -->
<div style="
    background: white;
    padding: 3rem 2rem;
    display: grid;
    grid-template-columns: 1fr 1fr 1fr 1fr;
    gap: 2rem;
    text-align: center;
    border-bottom: 1px solid #eee;
">
    <div>
        <h3 style="color: #e63946; font-size: 2.5rem; margin: 0;">99+</h3>
        <p style="color: #999; margin: 0.5rem 0 0 0;">Ürün Seçeneği</p>
    </div>
    <div>
        <h3 style="color: #e63946; font-size: 2.5rem; margin: 0;">5 Formatı</h3>
        <p style="color: #999; margin: 0.5rem 0 0 0;">AI, SVG, PNG, PDF, EPS</p>
    </div>
    <div>
        <h3 style="color: #e63946; font-size: 2.5rem; margin: 0;">24/7</h3>
        <p style="color: #999; margin: 0.5rem 0 0 0;">Hızlı İndirme</p>
    </div>
    <div>
        <h3 style="color: #e63946; font-size: 2.5rem; margin: 0;">30 Günü</h3>
        <p style="color: #999; margin: 0.5rem 0 0 0;">Para İade Garantisi</p>
    </div>
</div>

<!-- Featured Products Section -->
<div style="max-width: 1200px; margin: 4rem auto; padding: 0 2rem;">
    <div style="text-align: center; margin-bottom: 3rem;">
        <h2 style="font-size: 2.5rem; margin: 0 0 0.5rem 0;">💎 Öne Çıkan Ürünler</h2>
        <p style="color: #999; font-size: 1.1rem; margin: 0;">
            En popüler ve en çok satılan vektör grafiklerimiz
        </p>
    </div>

    <?php if (!empty($popularProducts)): ?>
        <div class="products-grid" style="
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 2rem;
            margin-bottom: 3rem;
        ">
            <?php foreach (array_slice($popularProducts, 0, 6) as $product): ?>
                <div class="product-card" style="
                    background: white;
                    border-radius: 12px;
                    overflow: hidden;
                    box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                    transition: all 0.3s ease;
                    cursor: pointer;
                "
                onmouseover="this.style.transform='translateY(-8px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.15)';"
                onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 12px rgba(0,0,0,0.08)';">
                    
                    <!-- Product Image -->
                    <a href="<?php echo APP_URL; ?>/product-detail.php?id=<?php echo $product['id']; ?>" style="text-decoration: none;">
                        <div style="
                            height: 200px;
                            background: #faf8f6;
                            overflow: hidden;
                            position: relative;
                        ">
                            <img 
                                src="<?php echo htmlspecialchars($product['image']); ?>" 
                                alt="<?php echo htmlspecialchars($product['title']); ?>"
                                loading="lazy"
                                style="
                                    width: 100%;
                                    height: 100%;
                                    object-fit: cover;
                                    transition: transform 0.3s ease;
                                "
                                onmouseover="this.style.transform='scale(1.05)';"
                                onmouseout="this.style.transform='scale(1)';"
                            >
                            <div style="
                                position: absolute;
                                top: 10px;
                                right: 10px;
                                background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                                color: white;
                                padding: 0.5rem 1rem;
                                border-radius: 20px;
                                font-size: 0.9rem;
                                font-weight: 600;
                            ">
                                ⭐ Popüler
                            </div>
                        </div>
                    </a>

                    <!-- Product Info -->
                    <div style="padding: 1.5rem;">
                        <span style="
                            display: inline-block;
                            background: #f4a0a0;
                            color: white;
                            padding: 0.3rem 0.8rem;
                            border-radius: 4px;
                            font-size: 0.8rem;
                            font-weight: 600;
                            margin-bottom: 0.75rem;
                        ">
                            <?php echo htmlspecialchars(ucfirst($product['category'])); ?>
                        </span>

                        <h3 style="
                            margin: 0 0 0.5rem 0;
                            font-size: 1rem;
                            line-height: 1.4;
                            min-height: 2.8rem;
                        ">
                            <a href="<?php echo APP_URL; ?>/product-detail.php?id=<?php echo $product['id']; ?>" style="
                                color: #2d2d2d;
                                text-decoration: none;
                                transition: color 0.3s ease;
                            "
                            onmouseover="this.style.color='#e63946';"
                            onmouseout="this.style.color='#2d2d2d';">
                                <?php echo htmlspecialchars(substr($product['title'], 0, 50)); ?>
                            </a>
                        </h3>

                        <!-- Price & Button -->
                        <div style="
                            display: flex;
                            justify-content: space-between;
                            align-items: center;
                            margin-top: 1rem;
                            padding-top: 1rem;
                            border-top: 1px solid #eee;
                        ">
                            <span style="
                                color: #e63946;
                                font-weight: 700;
                                font-size: 1.3rem;
                            ">
                                $<?php echo number_format($product['price'], 2); ?>
                            </span>
                            <button 
                                onclick="addToCart(<?php echo $product['id']; ?>, '<?php echo htmlspecialchars($product['title']); ?>')"
                                style="
                                    background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                                    color: white;
                                    border: none;
                                    padding: 0.6rem 1rem;
                                    border-radius: 6px;
                                    cursor: pointer;
                                    font-weight: 600;
                                    font-size: 0.9rem;
                                    transition: all 0.3s ease;
                                "
                                onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 4px 12px rgba(230, 57, 70, 0.3)';"
                                onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';"
                            >
                                🛒 Ekle
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- View All Button -->
        <div style="text-align: center; margin: 3rem 0;">
            <a 
                href="<?php echo APP_URL; ?>/products.php"
                style="
                    display: inline-block;
                    background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                    color: white;
                    padding: 1rem 2.5rem;
                    border-radius: 10px;
                    text-decoration: none;
                    font-weight: 700;
                    font-size: 1.1rem;
                    transition: all 0.3s ease;
                "
                onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.3)';"
                onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';"
            >
                Tüm Ürünleri Görüntüle (99+) →
            </a>
        </div>
    <?php endif; ?>
</div>

<!-- Categories Section -->
<?php if (!empty($categories)): ?>
    <div style="
        background: #faf8f6;
        padding: 4rem 2rem;
        margin: 2rem 0;
    ">
        <div style="max-width: 1200px; margin: 0 auto;">
            <div style="text-align: center; margin-bottom: 3rem;">
                <h2 style="font-size: 2.5rem; margin: 0 0 0.5rem 0;">🎨 Kategoriler</h2>
                <p style="color: #999; font-size: 1.1rem; margin: 0;">
                    Aradığınız tema başlığı altında kümenizin bulun
                </p>
            </div>

            <div style="
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                gap: 1.5rem;
            ">
                <?php foreach (array_slice($categories, 0, 8) as $category): ?>
                    <a 
                        href="<?php echo APP_URL; ?>/products.php?category=<?php echo htmlspecialchars($category); ?>"
                        style="
                            background: white;
                            padding: 2rem;
                            border-radius: 12px;
                            text-align: center;
                            text-decoration: none;
                            color: #2d2d2d;
                            transition: all 0.3s ease;
                            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
                        "
                        onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.15)';"
                        onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 2px 12px rgba(0,0,0,0.08)';"
                    >
                        <div style="font-size: 2.5rem; margin-bottom: 1rem;">
                            <?php 
                                // Category emoji mapping
                                $emojis = [
                                    'vectors' => '💕',
                                    'wedding' => '👰',
                                    'love' => '❤️',
                                    'romance' => '💑',
                                    'frames' => '🖼️',
                                    'decorations' => '🎀',
                                    'text' => '📝',
                                    'elements' => '✨'
                                ];
                                echo isset($emojis[$category]) ? $emojis[$category] : '💎';
                            ?>
                        </div>
                        <h4 style="margin: 0; font-size: 1.1rem; font-weight: 600;">
                            <?php echo htmlspecialchars(ucfirst($category)); ?>
                        </h4>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Benefits Section -->
<div style="max-width: 1200px; margin: 4rem auto; padding: 0 2rem;">
    <div style="text-align: center; margin-bottom: 3rem;">
        <h2 style="font-size: 2.5rem; margin: 0 0 0.5rem 0;">✨ Neden CDVectors?</h2>
    </div>

    <div style="
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        gap: 2rem;
    ">
        <!-- Benefit 1 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">🚀</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">Anında İndirme</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                Ödeme yaptiktan hemen sonra dosyalarınız indirilmeye hazır. 24/7 erişim.
            </p>
        </div>

        <!-- Benefit 2 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">🎯</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">Detaylı Tasarım</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                Her ürün profesyonelce tasarlanmış ve ürgün kalitesiyle hazırlanmıştır.
            </p>
        </div>

        <!-- Benefit 3 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">💯</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">30 Günü Para İadesi</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                Memnun değilseniz, 30 gün içinde hiçbir soruyla iade puan.
            </p>
        </div>

        <!-- Benefit 4 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">📦</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">5 Format</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                AI, SVG, PNG, PDF, EPS - tüm tasarım programlarında kullanılan.
            </p>
        </div>

        <!-- Benefit 5 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">🔒</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">Güvenli Ödeme</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                Paddle ile kripto korumalar kişisel ve ödeme bilgileriniz güvendedir.
            </p>
        </div>

        <!-- Benefit 6 -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">👥</div>
            <h4 style="margin: 0 0 0.75rem 0; font-size: 1.2rem;">Ticari Kullanım</h4>
            <p style="color: #666; margin: 0; line-height: 1.6;">
                Tüm ürünleri ticari projelerde kullanabilirsiniz. Lisans endişesi yok.
            </p>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div style="
    background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
    color: white;
    padding: 4rem 2rem;
    text-align: center;
    margin-top: 4rem;
">
    <h2 style="font-size: 2.5rem; margin: 0 0 1rem 0;">💝 Hemen Başlayın!</h2>
    <p style="font-size: 1.2rem; margin: 0 0 2rem 0; opacity: 0.95;">
        1000+ harika ürün explore et ve bir tanesini seç. Tüm ürünler anında indirilir.
    </p>
    <a 
        href="<?php echo APP_URL; ?>/products.php"
        style="
            display: inline-block;
            background: white;
            color: #e63946;
            padding: 1rem 2.5rem;
            border-radius: 10px;
            text-decoration: none;
            font-weight: 700;
            font-size: 1.1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        "
        onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 25px rgba(0,0,0,0.3)';"
        onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 15px rgba(0,0,0,0.2)';"
    >
        🛍️ Ürünleri Keşfet Şimdi
    </a>
</div>

<!-- JavaScript for Cart -->
<script>
function addToCart(productId, productTitle) {
    let cart = JSON.parse(localStorage.getItem('cart')) || [];
    const existingItem = cart.find(item => item.id === productId);

    if (existingItem) {
        existingItem.quantity += 1;
    } else {
        cart.push({
            id: productId,
            title: productTitle,
            quantity: 1
        });
    }

    localStorage.setItem('cart', JSON.stringify(cart));
    updateCartCount();
    alert(productTitle + ' sepete eklendi! 🛒');
}

function updateCartCount() {
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
    const cartCountEl = document.getElementById('cart-count');
    if (cartCountEl) {
        cartCountEl.textContent = totalItems;
    }
}

window.addEventListener('DOMContentLoaded', updateCartCount);
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
