<?php
/**
 * Order Success Page
 * Displays after successful payment
 */

require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/database.php';

$db = Database::getInstance();
$pageTitle = 'Sipariş Başarılı';

// Get order ID from session or URL
$orderId = isset($_GET['order_id']) ? (int)$_GET['order_id'] : 
           (isset($_SESSION['last_order_id']) ? $_SESSION['last_order_id'] : 0);

$order = null;
$orderItems = [];

if ($orderId > 0) {
    // Fetch order details from database
    $orderQuery = "SELECT * FROM orders WHERE id = ?";
    $result = $db->query($orderQuery, [$orderId], 'i');
    $orders = $result;
    
    if (!empty($orders)) {
        $order = $orders[0];
        
        // Fetch order items
        $itemsQuery = "SELECT * FROM order_items WHERE order_id = ?";
        $itemsResult = $db->query($itemsQuery, [$orderId], 'i');
        $orderItems = $itemsResult;
    }
}

require_once __DIR__ . '/includes/header.php';
?>

<div style="max-width: 800px; margin: 0 auto; padding: 2rem 0;">
    
    <?php if ($order): ?>
        <!-- Success Message -->
        <div style="
            text-align: center;
            background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
            color: white;
            padding: 3rem 2rem;
            border-radius: 12px;
            margin-bottom: 2rem;
        ">
            <div style="font-size: 3rem; margin-bottom: 1rem;">✅</div>
            <h1 style="margin: 0 0 0.5rem 0;">Siparişiniz Başarılı!</h1>
            <p style="margin: 0; font-size: 1.1rem; opacity: 0.95;">
                Ödeme başarıyla tamamlandı. Dosyalarınız karşıdan yüklenmeye hazırlanıyor.
            </p>
        </div>

        <!-- Order Details -->
        <div style="
            background: white;
            padding: 2rem;
            border-radius: 12px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            margin-bottom: 2rem;
        ">
            <h2 style="margin-top: 0;">📋 Sipariş Detayları</h2>

            <!-- Order Code & Info -->
            <div style="
                background: #faf8f6;
                padding: 1.5rem;
                border-radius: 8px;
                margin-bottom: 2rem;
                border-left: 4px solid #ff6b9d;
            ">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-bottom: 1rem;">
                    <div>
                        <p style="color: #999; margin: 0 0 0.5rem 0; font-size: 0.9rem;">Sipariş No</p>
                        <p style="margin: 0; font-size: 1.3rem; font-weight: 600; color: #2d2d2d;">
                            <?php echo htmlspecialchars($order['order_code']); ?>
                        </p>
                    </div>
                    <div>
                        <p style="color: #999; margin: 0 0 0.5rem 0; font-size: 0.9rem;">Sipariş Tarihi</p>
                        <p style="margin: 0; font-size: 1.1rem; color: #2d2d2d;">
                            <?php echo date('d.m.Y H:i', strtotime($order['created_at'])); ?>
                        </p>
                    </div>
                </div>
                <p style="margin: 0; color: #666;">
                    <strong>Toplam Tutar:</strong> 
                    <span style="color: #e63946; font-weight: 600; font-size: 1.2rem;">
                        $<?php echo number_format($order['total_amount'], 2); ?>
                    </span>
                </p>
            </div>

            <!-- Customer Information -->
            <div style="margin-bottom: 2rem;">
                <h3>👤 Müşteri Bilgileri</h3>
                <p style="margin: 0.5rem 0;">
                    <strong>Ad:</strong> <?php echo htmlspecialchars($order['customer_name']); ?>
                </p>
                <p style="margin: 0.5rem 0;">
                    <strong>Email:</strong> <?php echo htmlspecialchars($order['customer_email']); ?>
                </p>
                <p style="margin: 0.5rem 0;">
                    <strong>Telefon:</strong> <?php echo htmlspecialchars($order['customer_phone'] ?? 'Belirtilmemiş'); ?>
                </p>
                <p style="margin: 0.5rem 0;">
                    <strong>Adres:</strong> <?php echo htmlspecialchars($order['billing_address']); ?>
                </p>
            </div>

            <!-- Order Items -->
            <?php if (!empty($orderItems)): ?>
                <div style="margin-bottom: 2rem;">
                    <h3>📦 Ürünler</h3>
                    <div style="
                        background: #faf8f6;
                        padding: 1rem;
                        border-radius: 8px;
                    ">
                        <?php foreach ($orderItems as $item): ?>
                            <div style="
                                display: flex;
                                justify-content: space-between;
                                padding: 0.75rem 0;
                                border-bottom: 1px solid #eee;
                            ">
                                <div>
                                    <p style="margin: 0; font-weight: 600;">
                                        Ürün ID: <?php echo htmlspecialchars($item['product_id']); ?>
                                    </p>
                                    <p style="margin: 0.25rem 0; color: #999; font-size: 0.9rem;">
                                        Miktar: <?php echo htmlspecialchars($item['quantity']); ?>
                                    </p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Download Instructions -->
            <div style="
                background: #fff3cd;
                border: 1px solid #ffc107;
                padding: 1.5rem;
                border-radius: 8px;
                margin-bottom: 2rem;
            ">
                <h3 style="margin-top: 0;">📥 Dosyaları İndir</h3>
                <p style="margin-bottom: 1rem;">
                    Satın aldığınız ürünlerin dosyalarını aşağıdaki bağlantıdan indirebilirsiniz:
                </p>
                <a 
                    href="<?php echo APP_URL; ?>/my-downloads.php?order_id=<?php echo $orderId; ?>"
                    style="
                        display: inline-block;
                        background: #ffc107;
                        color: #333;
                        padding: 1rem 2rem;
                        border-radius: 8px;
                        text-decoration: none;
                        font-weight: 600;
                        transition: all 0.3s ease;
                    "
                    onmouseover="this.style.backgroundColor='#ffb007';"
                    onmouseout="this.style.backgroundColor='#ffc107';"
                >
                    Dosyaları İndir 📥
                </a>
                <p style="color: #999; font-size: 0.9rem; margin-top: 1rem;">
                    * Dosyalar 1 saat boyunca kullanılabilecek. Lütfen indirme noktasında saat saat kontrol edin.
                </p>
            </div>
        </div>

        <!-- Next Steps -->
        <div style="
            background: #f0f8ff;
            border: 1px solid #87ceeb;
            padding: 2rem;
            border-radius: 12px;
            margin-bottom: 2rem;
        ">
            <h3 style="margin-top: 0;">ℹ️ Sonraki Adımlar</h3>
            <ol style="color: #333;">
                <li style="margin-bottom: 1rem;">
                    <strong>Onay E-postası:</strong> Sipariş onayı ve indirme bağlantısı 
                    <span style="background: #fff; padding: 0.25rem 0.5rem; border-radius: 4px;">
                        <?php echo htmlspecialchars($order['customer_email']); ?>
                    </span> 
                    adresine gönderilecektir.
                </li>
                <li style="margin-bottom: 1rem;">
                    <strong>Dosya İndirme:</strong> Satın aldığınız tüm dosyaları yukarıdaki bağlantıdan indirebilirsiniz.
                </li>
                <li style="margin-bottom: 1rem;">
                    <strong>Teknik Destek:</strong> Herhangi bir sorun yaşanırsa 
                    <a href="<?php echo APP_URL; ?>/support.php" style="color: #e63946;">destek sayfamızı</a> ziyaret edin.
                </li>
                <li>
                    <strong>Geri Dönüş:</strong> 30 gün içinde hiçbir soru sorulmadan ürünü iade edebilirsiniz.
                </li>
            </ol>
        </div>

        <!-- Continue Shopping -->
        <div style="text-align: center;">
            <a 
                href="<?php echo APP_URL; ?>/products.php"
                style="
                    display: inline-block;
                    background: linear-gradient(135deg, #ff6b9d 0%, #e63946 100%);
                    color: white;
                    padding: 1rem 2rem;
                    border-radius: 8px;
                    text-decoration: none;
                    font-weight: 600;
                    transition: all 0.3s ease;
                "
                onmouseover="this.style.transform='translateY(-3px)'; this.style.boxShadow='0 8px 24px rgba(230, 57, 70, 0.3)';"
                onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='none';"
            >
                Daha Fazla Ürün Keşfet 💕
            </a>
        </div>

    <?php else: ?>
        <!-- No Order Found -->
        <div style="
            text-align: center;
            background: #fff3cd;
            padding: 3rem 2rem;
            border-radius: 12px;
            margin-bottom: 2rem;
            border: 1px solid #ffc107;
        ">
            <div style="font-size: 2rem; margin-bottom: 1rem;">⚠️</div>
            <h2>Sipariş Bulunamadı</h2>
            <p style="color: #666; margin-bottom: 2rem;">
                Maalesef, siparişinizin detayları bulunamadı. 
                Lütfen email adresinizi kontrol edin veya destek ekibimize başvurun.
            </p>
            <a 
                href="<?php echo APP_URL; ?>/products.php"
                style="
                    display: inline-block;
                    background: #ffc107;
                    color: #333;
                    padding: 1rem 2rem;
                    border-radius: 8px;
                    text-decoration: none;
                    font-weight: 600;
                    transition: all 0.3s ease;
                "
                onmouseover="this.style.backgroundColor='#ffb007';"
                onmouseout="this.style.backgroundColor='#ffc107';"
            >
                Anasayfaya Dön
            </a>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
