<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Proxy Trafik Oluşturucu</title>
</head>
<body>

<h2>Proxy Trafik Oluşturucu</h2>

<form method="post">
    <label for="proxies">Proxy Adresleri (Her satıra bir proxy):</label><br>
    <textarea id="proxies" name="proxies" rows="5" cols="50" required></textarea><br><br>

    <label for="url">Ziyaret Edilecek Web Adresi:</label><br>
    <input type="text" id="url" name="url" required><br><br>

    <input type="submit" value="Trafik Gönder">
</form>

<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $proxies = explode("\n", trim($_POST['proxies'])); // Proxy adreslerini satır satır ayır
    $url = filter_var($_POST['url'], FILTER_VALIDATE_URL); // Web adresini doğrula

    if ($url && !empty($proxies)) {
        echo "<h3>Ziyaret Edilen URL: $url</h3>";
        echo "<h4>Sonuçlar:</h4><ul>";

        foreach ($proxies as $proxy) {
            $proxy = trim($proxy);
            if (!empty($proxy)) {
                $result = sendTraffic($proxy, $url);
                echo "<li>Proxy: $proxy - $result</li>";
            }
        }

        echo "</ul>";
    } else {
        echo "<p>Lütfen geçerli bir URL ve proxy adresleri girin.</p>";
    }
}

function sendTraffic($proxy, $url) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_PROXY, $proxy);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 200) {
        return "Başarılı (HTTP Kod: $httpCode)";
    } else {
        return "Başarısız (HTTP Kod: $httpCode)";
    }
}
?>

</body>
</html>
