<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get backlink URLs from the text area
    $backlinkUrls = explode("\n", trim($_POST['backlinks']));
    $backlinkUrls = array_map('trim', $backlinkUrls); // Trim each URL

    // Ping services
    $pingomaticUrl = "http://pingomatic.com/ping/";
    $googlePingUrl = "http://blogsearch.google.com.tr/ping/RPC2";
    $googlePingUrl = "http://blogsearch.google.com/ping/RPC2";
    $googlePingUrl = "http://rpc.pingomatic.com";   
    // Function to send a ping
    function pingService($url, $serviceUrl) {
        $ch = curl_init();

        // Append URL for the respective service
        if (strpos($serviceUrl, "google.com") !== false) {
            $pingUrl = $serviceUrl . urlencode($url);
        } else {
            $pingUrl = $serviceUrl;
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                'title' => 'Backlink Ping',
                'blogurl' => $url,
                'rssurl' => $url,
            ]));
        }

        // Set cURL options
        curl_setopt($ch, CURLOPT_URL, $pingUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10); // Timeout after 10 seconds

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            echo "Error pinging $url to service $serviceUrl: $error<br>";
        } else {
            echo "Pinged $url to service $serviceUrl. HTTP Code: $httpCode<br>";
        }

        curl_close($ch);
    }

    // Process each backlink URL
    foreach ($backlinkUrls as $url) {
        if (!empty($url)) {
            // Pingomatic
            pingService($url, $pingomaticUrl);

            // Google Ping Service
            pingService($url, $googlePingUrl);
        }
    }
} else {
    // Display input form
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Backlink Pinger</title>
</head>
<body>
    <h1>Backlink Pinger</h1>
    <form method="POST">
        <label for="backlinks">Enter Backlink URLs (one per line):</label><br>
        <textarea name="backlinks" id="backlinks" rows="10" cols="50" required></textarea><br><br>
        <button type="submit">Ping Backlinks</button>
    </form>
</body>
</html>
<?php
}
?>