# cPanel Kurulum Talimatları

## Ön Hazırlık

1. **Dosyaları Hazırla**
   - vector-shop klasörünü ZIP'le
   - .env dosyasını kontrol et (gizli bilgiler içermemeli, sunucuda düzenlenecek)

## cPanel Python App Kurulumu

### 1. Python Uygulaması Oluştur

cPanel → Setup Python App → CREATE APPLICATION

**Formda dolduracakların:**

```
Python version: 3.7 veya üzeri (mevcut en yüksek)

Application root: /home/KULLANICIADI/vector-shop
(KULLANICIADI yerine cPanel kullanıcı adınızı yazın)

Application URL: 
- Domain seçin (örn: yourdomain.com)
- Alt domain kullanıyorsanız: shop.yourdomain.com

Application startup file: passenger_wsgi.py

Application Entry point: application
```

**Environment variables (Ortam Değişkenleri):**

ADD VARIABLE butonuna tıklayarak aşağıdakileri ekle:

```
Name: FLASK_SECRET_KEY
Value: rastgele-güçlü-bir-anahtar-123456789

Name: DATABASE_URL
Value: sqlite:///vector_shop.db

Name: ADMIN_USERNAME
Value: admin

Name: ADMIN_PASSWORD
Value: güçlü-şifreniz

Name: SMTP_SERVER
Value: smtp.gmail.com

Name: SMTP_PORT
Value: 587

Name: SMTP_USERNAME
Value: youremail@gmail.com

Name: SMTP_PASSWORD
Value: your-app-password

Name: FROM_EMAIL
Value: youremail@gmail.com

Name: PADDLE_VENDOR_ID
Value: your-paddle-vendor-id

Name: PADDLE_API_KEY
Value: your-paddle-api-key

Name: PADDLE_PUBLIC_KEY
Value: your-paddle-public-key

Name: PADDLE_SHARED_SECRET
Value: your-paddle-webhook-secret

Name: GITHUB_TOKEN
Value: your-github-token

Name: GITHUB_REPO
Value: username/repo-name
```

CREATE butonuna tıkla → Uygulama oluşturulacak

---

## 2. Dosyaları Yükle

### File Manager Kullanarak:

1. cPanel → File Manager aç
2. `vector-shop` klasörüne git
3. vector-shop.zip dosyasını yükle
4. Extract (Çıkart) ile dosyaları çıkart
5. Gereksiz ZIP dosyasını sil

### FTP Kullanarak:

1. FTP client (FileZilla vb.) ile bağlan
2. `/home/KULLANICIADI/vector-shop/` klasörüne git
3. Tüm dosyaları yükle

---

## 3. Virtual Environment ve Bağımlılıkları Yükle

cPanel → Setup Python App → Uygulamanızı bulun

**Sağ üstte "Edit" butonuna tıkla**

Sayfanın altında terminal komutu göreceksin:

```bash
source /home/KULLANICIADI/virtualenv/vector-shop/3.7/bin/activate && cd /home/KULLANICIADI/vector-shop
```

Bu komutu kopyala!

---

## 4. SSH/Terminal ile Bağlan

### Yöntem 1: cPanel Terminal
1. cPanel → Terminal
2. Yukarıdaki komutu yapıştır ve Enter

### Yöntem 2: SSH Client
```bash
ssh KULLANICIADI@sunucuip
# Şifrenizi girin
```

Virtual environment'ı aktif et:
```bash
source /home/KULLANICIADI/virtualenv/vector-shop/3.7/bin/activate
cd /home/KULLANICIADI/vector-shop
```

---

## 5. Python Paketlerini Yükle

```bash
pip install --upgrade pip
pip install -r requirements.txt
```

Bu komut tüm gerekli paketleri yükleyecek (Flask, SQLAlchemy vb.)

---

## 6. Veritabanını Oluştur

```bash
python -c "from app import app, db; app.app_context().push(); db.create_all(); print('Veritabanı oluşturuldu!')"
```

---

## 7. veri.csv Dosyasını Import Et

veri.csv dosyasını vector-shop klasörüne yükle (File Manager veya FTP ile)

Sonra terminalde:

```bash
python import_veri.py
```

Bu işlem 3000+ ürünü import edecek (birkaç dakika sürebilir)

---

## 8. Uygulamayı Yeniden Başlat

cPanel → Setup Python App → Uygulamanızı bulun → **RESTART** butonuna tıkla

Veya terminalde:
```bash
touch tmp/restart.txt
```

---

## 9. Test Et

Tarayıcınızda:
```
https://yourdomain.com
```

Admin paneline giriş:
```
https://yourdomain.com/admin/login
```

---

## Sorun Giderme

### Hata: "Application error"

1. **Log dosyasını kontrol et:**
   ```bash
   cat logs/passenger.log
   # veya
   tail -f logs/2026-01-19.txt
   ```

2. **İzinleri kontrol et:**
   ```bash
   chmod 755 passenger_wsgi.py
   chmod 755 app.py
   chmod -R 755 templates static utils
   ```

3. **Veritabanı izinleri:**
   ```bash
   chmod 664 vector_shop.db
   chmod 775 .
   ```

### ModuleNotFoundError

Bazı paketler eksik olabilir:
```bash
source /home/KULLANICIADI/virtualenv/vector-shop/3.7/bin/activate
pip install Flask Flask-SQLAlchemy python-dotenv cryptography requests PyGithub
```

### Static dosyalar yüklenmiyor

.htaccess dosyasını kontrol et ve şunu ekle:
```apache
<IfModule mod_headers.c>
    Header set Access-Control-Allow-Origin "*"
</IfModule>
```

### Paddle Webhook çalışmıyor

1. Paddle Dashboard → Webhooks
2. URL'yi güncelle: `https://yourdomain.com/webhook/paddle`
3. Shared Secret'i kontrol et

---

## Güvenlik Notları

1. **.env dosyası kullanma** - cPanel Environment Variables kullan
2. **Güçlü şifreler** - Admin ve SMTP için
3. **HTTPS** - cPanel otomatik SSL sertifikası sağlar (Let's Encrypt)
4. **Firewall** - cPanel güvenlik ayarlarını kontrol et

---

## Performans İyileştirmeleri

1. **Passenger ayarları** (.htaccess):
   ```apache
   PassengerMinInstances 2
   PassengerMaxPoolSize 6
   ```

2. **Veritabanı optimizasyonu:**
   ```bash
   python -c "from app import app, db; from models import Product; app.app_context().push(); db.session.execute('VACUUM'); print('DB optimized')"
   ```

---

## Yedekleme

Düzenli yedekleme için cron job oluştur:

cPanel → Cron Jobs

```bash
0 2 * * * cd /home/KULLANICIADI/vector-shop && tar -czf backups/backup-$(date +\%Y\%m\%d).tar.gz *.db logs/
```

---

## Cloudflare Entegrasyonu

1. Cloudflare hesabınıza domain ekleyin
2. Nameserver'ları değiştirin
3. SSL/TLS → Full (strict)
4. Firewall rules ekleyin
5. Page rules ile cache optimize edin

---

Sorularınız için: logs/YYYY-MM-DD.txt dosyasını kontrol edin!
