# VectorShop - Premium Stock Vector Satış Platformu (PHP)

Modern, güvenli ve profesyonel dijital ürün satış sistemi. Paddle ödeme entegrasyonu ve GitHub Releases üzerinden şifreli dosya teslimatı.

## 🎨 Özellikler

- ✅ **Modern Tema**: Gradient renkler, responsive tasarım
- ✅ **Paddle Ödeme**: Güvenli ödeme işlemleri
- ✅ **CSV Import**: veri.csv formatından 3000+ ürün import
- ✅ **Adobe Stock Görselleri**: Direkt URL entegrasyonu
- ✅ **Kategori ve Etiket Sistemi**: Gelişmiş filtreleme
- ✅ **Admin Paneli**: Ürün, kupon, sipariş yönetimi
- ✅ **Email Bildirimleri**: Otomatik teslimat e-postaları
- ✅ **GitHub Storage**: Dosyalar sunucuda değil, GitHub'da
- ✅ **SQLite Veritabanı**: Kolay kurulum, bakım gerektirmez
- ✅ **Log Sistemi**: Detaylı günlük kayıtları

## 📁 Proje Yapısı

```
vector-shop-php/
├── index.php                    # Ana sayfa (ürün vitrini)
├── product.php                  # Ürün detay sayfası
├── success.php                  # Ödeme başarılı sayfası
├── .htaccess                    # URL rewrite ve güvenlik
├── .env                         # Konfigürasyon (oluşturulacak)
├── admin/
│   ├── login.php                # Admin girişi
│   ├── dashboard.php            # Yönetim paneli
│   └── import.php               # CSV import arayüzü
├── webhook/
│   └── paddle.php               # Paddle webhook handler
├── includes/
│   ├── config.php               # Ayarlar ve sabitler
│   ├── db.php                   # Veritabanı sınıfı
│   ├── utils.php                # Yardımcı fonksiyonlar
│   └── mailer.php               # Email gönderim
├── assets/
│   ├── css/
│   │   └── style.css            # Modern tema CSS
│   └── js/
├── data/
│   └── vectorshop.db            # SQLite veritabanı (otomatik)
├── logs/
│   └── YYYY-MM-DD.txt           # Günlük log dosyaları
└── uploads/                     # Geçici dosyalar
```

## 🚀 cPanel Kurulumu (Adım Adım)

### Adım 1: Dosyaları Hazırla

**Bilgisayarınızda:**

```powershell
# Proje klasörüne git
cd C:\Users\Asus\Desktop\seller

# veri.csv dosyasını vector-shop-php klasörüne kopyala
Copy-Item vector-shop\veri.csv vector-shop-php\

# ZIP oluştur
Compress-Archive -Path vector-shop-php -DestinationPath vector-shop-php.zip
```

### Adım 2: cPanel'e Dosya Yükle

1. **cPanel → File Manager** aç
2. `public_html` klasörüne git
3. **Upload** butonuna tıkla
4. `vector-shop-php.zip` dosyasını yükle
5. ZIP'e sağ tıkla → **Extract**
6. Dosyaları `public_html` içine taşı:
   - `vector-shop-php` klasörü içindeki tüm dosyaları
   - Direkt `public_html` içine taşıyın

### Adım 3: .env Dosyasını Oluştur

**cPanel File Manager'da:**

1. `public_html` klasöründe yeni dosya oluştur: `.env`
2. İçeriği aşağıdaki gibi düzenle:

```env
SITE_NAME=VectorShop
SITE_URL=https://yourdomain.com
ADMIN_EMAIL=admin@yourdomain.com

DB_PATH=data/vectorshop.db

ADMIN_USERNAME=admin
ADMIN_PASSWORD=güçlü_şifreniz_123

PADDLE_VENDOR_ID=
PADDLE_API_KEY=
PADDLE_PUBLIC_KEY=
PADDLE_SHARED_SECRET=

GITHUB_TOKEN=
GITHUB_REPO=

SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USERNAME=youremail@gmail.com
SMTP_PASSWORD=your-gmail-app-password
SMTP_FROM_EMAIL=noreply@yourdomain.com
SMTP_FROM_NAME=VectorShop

SESSION_SECRET=random-secret-key-123456789
ENCRYPTION_KEY=12345678901234567890123456789012

DEBUG_MODE=false
```

### Adım 4: İzinleri Ayarla

**cPanel File Manager'da:**

Şu klasörlere **755** izni ver (sağ tık → Change Permissions):
- `data/`
- `logs/`
- `uploads/`

### Adım 5: CSV Dosyasını Import Et

**Yöntem 1: Web Arayüzü (Önerilen)**

1. Tarayıcıda: `https://yourdomain.com/admin/login.php`
2. Kullanıcı adı: `admin`, Şifre: `.env`'de belirlediğiniz
3. **Import CSV** menüsüne tıkla
4. `veri.csv` dosyasını seç ve **Import** butonuna bas
5. İşlem 1-2 dakika sürebilir, bekleyin

**Yöntem 2: PHP CLI (Terminal)**

cPanel → Terminal veya SSH:

```bash
cd ~/public_html
php -r "require 'includes/config.php'; require 'includes/db.php'; \$db = Database::getInstance(); \$result = \$db->importFromCSV('veri.csv'); echo \$result['message'];"
```

### Adım 6: Siteyi Test Et

**Ana Sayfa:**
```
https://yourdomain.com
```

**Admin Panel:**
```
https://yourdomain.com/admin/login.php
```

## 🔧 Paddle Entegrasyonu

### 1. Paddle Hesabı Oluştur

1. https://paddle.com adresine git
2. Hesap oluştur ve verify et
3. **Dashboard** → **Developer Tools** → **Authentication**

### 2. API Bilgilerini Al

```
Vendor ID: Settings → Account → Vendor ID
API Key: Developer Tools → API Authentication → Create
Public Key: Developer Tools → Public Key
```

### 3. Webhook Ayarla

**Paddle Dashboard → Developer Tools → Webhooks:**

- Webhook URL: `https://yourdomain.com/webhook/paddle.php`
- Shared Secret: Kopyala ve `.env` dosyasına ekle

### 4. .env'yi Güncelle

```env
PADDLE_VENDOR_ID=12345
PADDLE_API_KEY=your-api-key
PADDLE_PUBLIC_KEY=your-public-key
PADDLE_SHARED_SECRET=your-webhook-secret
```

## 📧 Email Ayarları (Gmail)

### Gmail App Password Oluştur

1. https://myaccount.google.com/security
2. **2-Step Verification** aktif et
3. **App passwords** ara
4. **Select app** → **Mail**, **Device** → **Other** → `VectorShop`
5. **Generate** → 16 haneli şifreyi kopyala

### .env'de Email Ayarları

```env
SMTP_HOST=smtp.gmail.com
SMTP_PORT=587
SMTP_USERNAME=youremail@gmail.com
SMTP_PASSWORD=abcd efgh ijkl mnop  # 16 haneli app password
SMTP_FROM_EMAIL=noreply@yourdomain.com
SMTP_FROM_NAME=VectorShop
```

## 🛡️ Güvenlik

### SSL Sertifikası (Ücretsiz)

cPanel → **SSL/TLS Status** → **Run AutoSSL**

### Dosya İzinleri

```
Dosyalar: 644
Klasörler: 755
.env: 600 (hassas bilgi)
```

### Güvenlik Başlıkları

`.htaccess` dosyası otomatik olarak şunları sağlar:
- XSS Protection
- Clickjacking Prevention
- MIME Sniffing Protection

## 📊 Admin Panel Kullanımı

### Ürün Yönetimi

- **Görüntüleme**: Dashboard'da tüm ürünler
- **Silme**: Her ürün için Delete butonu
- **Import**: CSV ile toplu ürün ekleme

### Kupon Oluşturma

1. Dashboard'da "Create Coupon" formu
2. Kupon kodu gir (örn: `SAVE20`)
3. İndirim yüzdesi (örn: `20`)
4. Maksimum kullanım sayısı (opsiyonel)
5. **Create Coupon** butonuna bas

### Sipariş Takibi

- **Recent Orders** tablosunda tüm siparişler
- Durum: Completed / Pending
- Teslimat: Sent / Pending (email gönderildi mi?)

### Logları İnceleme

```
logs/2026-01-19.txt
```

Her işlem otomatik loglanır:
- Ödeme işlemleri
- Email gönderimi
- Hata mesajları
- Admin girişleri

## 🐛 Sorun Giderme

### "Internal Server Error" Hatası

1. `.htaccess` dosyasını geçici olarak sil
2. PHP versiyonu 7.4+ olmalı (cPanel → Select PHP Version)
3. `data/` ve `logs/` klasör izinlerini kontrol et

### Email Gönderilmiyor

1. Gmail App Password doğru girildi mi?
2. SMTP ayarları `.env` dosyasında doğru mu?
3. Firewall SMTP portunu engelliyor olabilir
4. `logs/` klasöründeki hata mesajlarını kontrol et

### CSV Import Çalışmıyor

1. Dosya UTF-8 encoding'de mi?
2. Pipe `|` karakteri kullanılıyor mu?
3. İlk satır header olmalı
4. PHP `upload_max_filesize` limitini artır (cPanel → PHP Settings)

### Görseller Görünmüyor

1. `image_url` sütunu dolu mu?
2. URL'ler erişilebilir mi? (tarayıcıda test et)
3. HTTPS bağlantı sorunları olabilir

### Webhook Çalışmıyor

1. Paddle Shared Secret doğru mu?
2. Webhook URL: `https://yourdomain.com/webhook/paddle.php`
3. `logs/` klasöründe webhook isteklerini kontrol et
4. Paddle Dashboard'da webhook test et

## 🎯 Performans İyileştirmeleri

### cPanel Optimizasyonları

**PHP Settings:**
```
memory_limit = 256M
max_execution_time = 300
upload_max_filesize = 50M
post_max_size = 50M
```

**OPcache (cPanel → PHP Extensions):**
- opcache etkinleştir
- Performansı %50 artırır

### Veritabanı Optimizasyonu

Terminal'de (opsiyonel):

```bash
sqlite3 data/vectorshop.db "VACUUM;"
```

## 📱 Mobil Uyumluluk

Tema tamamen responsive:
- ✅ Mobil telefon
- ✅ Tablet
- ✅ Desktop

## 🌐 Çoklu Dil Desteği (İsteğe Bağlı)

`includes/config.php` dosyasında dil ayarları eklenebilir.

## 💾 Yedekleme

### Manuel Yedekleme

cPanel → **Backup Wizard** → **Full Backup**

### Otomatik Yedekleme (Cron Job)

cPanel → **Cron Jobs**:

```bash
0 2 * * * cd ~/public_html && tar -czf ~/backups/vectorshop-$(date +\%Y\%m\%d).tar.gz data/ logs/
```

## 📞 Destek

Sorun yaşıyorsanız:

1. `logs/YYYY-MM-DD.txt` dosyasını kontrol edin
2. `DEBUG_MODE=true` yapıp hatayı görüntüleyin
3. cPanel Error Log'ları inceleyin

## 📄 Lisans

MIT License - Ticari kullanım serbesttir.

## ✨ Güncellemeler

- **v1.0.0**: İlk sürüm
  - Temel ürün vitrin sistemi
  - Paddle ödeme entegrasyonu
  - CSV import özelliği
  - Admin paneli

---

**Kurulum sonrası ilk adımlar:**

1. ✅ Admin paneline gir (`/admin/login.php`)
2. ✅ CSV dosyasını import et
3. ✅ Paddle ayarlarını yap
4. ✅ Email ayarlarını test et
5. ✅ Test ödeme yap

**Başarılar! 🚀**
