<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/utils.php';

requireLogin();

$message = '';
$messageType = 'info';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file'];
    
    if ($file['error'] === UPLOAD_ERR_OK) {
        $tmpPath = $file['tmp_name'];
        
        $db = Database::getInstance();
        $result = $db->importFromCSV($tmpPath);
        
        $message = $result['message'];
        $messageType = $result['success'] ? 'success' : 'danger';
        
        if ($result['success']) {
            logMessage("CSV import completed: " . $result['message']);
        }
    } else {
        $message = 'File upload failed';
        $messageType = 'danger';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Import CSV - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1><?= SITE_NAME ?> - Import CSV</h1>
            <nav>
                <a href="/">Home</a>
                <a href="/admin/dashboard.php">Dashboard</a>
                <a href="?logout=1">Logout</a>
            </nav>
        </div>
    </header>

    <main class="container">
        <?php if ($message): ?>
            <div class="alert alert-<?= $messageType ?>">
                <?= htmlspecialchars($message) ?>
            </div>
        <?php endif; ?>

        <section class="admin-section">
            <h2>Import Products from CSV</h2>
            
            <div class="alert alert-info">
                <h3>CSV Format Requirements:</h3>
                <p>File must be pipe-delimited (|) with the following columns:</p>
                <code style="display: block; background: #f0f0f0; padding: 10px; margin: 10px 0; border-radius: 5px;">
                    id|title|description|price|image|category|tags|keywords|popular|permanentlink|customers
                </code>
                <p><strong>Example:</strong></p>
                <code style="display: block; background: #f0f0f0; padding: 10px; margin: 10px 0; border-radius: 5px; font-size: 0.85rem;">
                    1|Stock Vector|Beautiful design|3.00|https://example.com/img.jpg|vectors|tag1,tag2|word1,word2|true|https://link.com|customers
                </code>
            </div>
            
            <form method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label>Select CSV File (veri.csv):</label>
                    <input type="file" name="csv_file" accept=".csv" required>
                </div>
                
                <button type="submit" class="btn btn-success btn-large">Import CSV</button>
                <a href="/admin/dashboard.php" class="btn btn-secondary">Cancel</a>
            </form>
        </section>

        <section class="admin-section">
            <h3>Import Instructions:</h3>
            <ol>
                <li>Prepare your CSV file with pipe (|) delimiter</li>
                <li>First row must be the header</li>
                <li>Image URLs should be direct links (Adobe Stock, etc.)</li>
                <li>Popular field: use "true" or "false"</li>
                <li>Price must be a decimal number (e.g., 3.00)</li>
                <li>Existing products (by ID) will be updated</li>
                <li>New products will be added automatically</li>
            </ol>
        </section>
    </main>

    <footer>
        <div class="container">
            <p>&copy; <?= date('Y') ?> <?= SITE_NAME ?> Admin Panel. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>
