<?php
function sendEmail($to, $subject, $body) {
    $headers = "From: " . SMTP_FROM_NAME . " <" . SMTP_FROM_EMAIL . ">\r\n";
    $headers .= "Reply-To: " . SMTP_FROM_EMAIL . "\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    
    ini_set('SMTP', SMTP_HOST);
    ini_set('smtp_port', SMTP_PORT);
    ini_set('sendmail_from', SMTP_FROM_EMAIL);
    
    $success = mail($to, $subject, $body, $headers);
    
    if ($success) {
        logMessage("Email sent to: $to - Subject: $subject");
    } else {
        logMessage("Email failed to: $to - Subject: $subject", 'ERROR');
    }
    
    return $success;
}

function sendOrderEmail($order, $product, $downloadLinks) {
    $subject = "Your Order is Ready - " . $product['name'];
    
    $linksHtml = '';
    foreach ($downloadLinks as $link) {
        $size = round($link['size'] / 1024 / 1024, 2);
        $linksHtml .= "<li><a href=\"{$link['url']}\">{$link['name']}</a> ({$size} MB)</li>";
    }
    
    $body = "
    <!DOCTYPE html>
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
            .button { background: #667eea; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; display: inline-block; margin: 10px 0; }
            .info-box { background: white; padding: 20px; border-left: 4px solid #667eea; margin: 20px 0; }
            ul { padding-left: 20px; }
            li { margin: 10px 0; }
            .footer { text-align: center; padding: 20px; color: #666; font-size: 12px; }
        </style>
    </head>
    <body>
        <div class=\"container\">
            <div class=\"header\">
                <h1>Order Completed Successfully!</h1>
            </div>
            <div class=\"content\">
                <p>Dear {$order['customer_name']},</p>
                <p>Thank you for your purchase of <strong>{$product['name']}</strong>!</p>
                
                <div class=\"info-box\">
                    <h3>Download Information:</h3>
                    <p><strong>Password:</strong> <code style=\"background: #f0f0f0; padding: 5px 10px; border-radius: 3px;\">{$order['download_password']}</code></p>
                </div>
                
                <h3>Download Files:</h3>
                <ul>
                    $linksHtml
                </ul>
                
                <h3>How to Use:</h3>
                <ol>
                    <li>Download all file parts</li>
                    <li>Use WinRAR or 7-Zip to extract</li>
                    <li>Enter the password above when prompted</li>
                </ol>
                
                <div class=\"info-box\">
                    <p><strong>Order ID:</strong> {$order['order_id']}</p>
                    <p><strong>Amount Paid:</strong> " . formatPrice($order['amount']) . "</p>
                </div>
                
                <p>If you have any questions, please don't hesitate to contact us.</p>
                
                <p>Best regards,<br>" . SITE_NAME . " Team</p>
            </div>
            <div class=\"footer\">
                <p>&copy; " . date('Y') . " " . SITE_NAME . ". All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    return sendEmail($order['customer_email'], $subject, $body);
}
?>
