<?php
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/utils.php';

$productId = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$productId) {
    redirect('/');
}

$db = Database::getInstance()->getConnection();
$stmt = $db->prepare("SELECT * FROM products WHERE id = ? AND active = 1");
$stmt->execute([$productId]);
$product = $stmt->fetch();

if (!$product) {
    redirect('/');
}

$tags = $product['tags'] ? explode(',', $product['tags']) : [];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= htmlspecialchars($product['name']) ?> - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1><?= SITE_NAME ?></h1>
            <nav>
                <a href="/">Home</a>
                <a href="/admin/login.php">Admin</a>
            </nav>
        </div>
    </header>

    <main class="container">
        <div class="product-detail">
            <div class="product-detail-grid">
                <div>
                    <?php if ($product['image_url']): ?>
                        <img src="<?= htmlspecialchars($product['image_url']) ?>" 
                             alt="<?= htmlspecialchars($product['name']) ?>" 
                             class="product-detail-image">
                    <?php else: ?>
                        <div class="product-image placeholder" style="height: 400px; font-size: 8rem;">
                            <?= strtoupper(substr($product['name'], 0, 1)) ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="product-detail-info">
                    <?php if ($product['category']): ?>
                        <span class="product-category"><?= htmlspecialchars($product['category']) ?></span>
                    <?php endif; ?>
                    
                    <h1><?= htmlspecialchars($product['name']) ?></h1>
                    
                    <p class="product-detail-price"><?= formatPrice($product['price']) ?></p>
                    
                    <div class="product-meta">
                        <p><strong>Product ID:</strong> #<?= $product['csv_id'] ?? $product['id'] ?></p>
                        <p><strong>Category:</strong> <?= htmlspecialchars($product['category']) ?></p>
                        <p><strong>File Parts:</strong> <?= $product['file_parts_count'] ?></p>
                        <p><strong>Format:</strong> Encrypted ZIP</p>
                        <p><strong>Delivery:</strong> Instant via Email</p>
                    </div>
                    
                    <div style="margin-bottom: 2rem;">
                        <h3>Description</h3>
                        <p><?= nl2br(htmlspecialchars($product['description'])) ?></p>
                    </div>
                    
                    <?php if (!empty($tags)): ?>
                        <div class="tags">
                            <?php foreach (array_slice($tags, 0, 10) as $tag): ?>
                                <span class="tag"><?= htmlspecialchars(trim($tag)) ?></span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    
                    <a href="https://buy.paddle.com/product/<?= htmlspecialchars($product['paddle_product_id']) ?>" 
                       class="btn btn-large btn-block btn-success" 
                       style="margin-top: 2rem;">
                        Purchase Now - <?= formatPrice($product['price']) ?>
                    </a>
                    
                    <div class="alert alert-info" style="margin-top: 1.5rem;">
                        <p><strong>🔒 Secure Payment via Paddle</strong></p>
                        <p style="margin-top: 0.5rem; font-size: 0.9rem;">
                            After payment, you'll receive download links and password via email instantly.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="delivery-info" style="background: #f9f9f9; padding: 2rem; border-radius: 10px; margin-top: 2rem;">
                <h3>📦 How Delivery Works</h3>
                <ol style="padding-left: 1.5rem; margin-top: 1rem;">
                    <li style="margin-bottom: 0.8rem;">Complete your secure payment via Paddle</li>
                    <li style="margin-bottom: 0.8rem;">Receive download links and password to your email</li>
                    <li style="margin-bottom: 0.8rem;">Download all file parts</li>
                    <li style="margin-bottom: 0.8rem;">Extract using WinRAR/7-Zip with provided password</li>
                    <li style="margin-bottom: 0.8rem;">Start using your digital assets!</li>
                </ol>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: 2rem;">
            <a href="/" class="btn btn-secondary">← Back to Products</a>
        </div>
    </main>

    <footer>
        <div class="container">
            <p>&copy; <?= date('Y') ?> <?= SITE_NAME ?>. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>
